#!/bin/bash

SCHEDULE=""

stl() {
    $SCHEDULE python train_eval.py \
        --seed 0 \
        --encoder alexnet \
        --dataset stl10 \
        --feat_dim 128 \
        --batch_size 512 \
        $@
}

cifar() {
    $SCHEDULE python train_eval.py \
        --seed 0 \
        --encoder resnet \
        --dataset cifar10 \
        --feat_dim 3 \
        --batch_size 768 \
        $@
}

# STL10 Experiments

stl --method ssw --unif_w 256 --num_projections 1024
stl --method ssw --unif_w 256 --num_projections 2048
stl --method hypersphere --unif_w 0.96 --align_w 0.98
stl --method simclr

# CIFAR Experiments

cifar --method ssw --unif_w 256 --num_projections 12
cifar --method ssw --unif_w 256 --num_projections 24
cifar --method hypersphere --unif_w 0.96 --align_w 0.98
cifar --method simclr
